/*
 * Decompiled with CFR 0.152.
 */
package com.newcas.newcasficalcore;

import java.util.Date;
import ru.fls.swfm.DocumentProcessCallback;
import ru.fls.swfm.DocumentProcessResult;
import ru.fls.swfm.FiscalModuleException;
import ru.fls.swfm.NativeFiscalModule;
import ru.fls.swfm.TaxType;

public class SoftwareFiscaleModuleWrapper
implements DocumentProcessCallback {
    private final NativeFiscalModule module = new NativeFiscalModule();

    private static byte hexToByte(String hexString) {
        int firstDigit = SoftwareFiscaleModuleWrapper.toDigit(hexString.charAt(0));
        int secondDigit = SoftwareFiscaleModuleWrapper.toDigit(hexString.charAt(1));
        return (byte)((firstDigit << 4) + secondDigit);
    }

    private static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }

    private static byte[] decodeHexString(String hexString) {
        if (hexString.startsWith("0x")) {
            hexString = hexString.substring(2);
        }
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String supplied.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        int i = 0;
        while (i < hexString.length()) {
            bytes[i / 2] = SoftwareFiscaleModuleWrapper.hexToByte(hexString.substring(i, i + 2));
            i += 2;
        }
        return bytes;
    }

    private static String byteArrayToHexString(byte[] payload) {
        if (payload == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(payload.length);
        byte[] byArray = payload;
        int n = payload.length;
        int n2 = 0;
        while (n2 < n) {
            byte byteChar = byArray[n2];
            stringBuilder.append(String.format("%02X", byteChar));
            ++n2;
        }
        return stringBuilder.toString();
    }

    private byte[] toBytes(String data) {
        return SoftwareFiscaleModuleWrapper.decodeHexString(data);
    }

    private String fromBytes(byte[] data) {
        return SoftwareFiscaleModuleWrapper.byteArrayToHexString(data);
    }

    public String version() throws FiscalModuleException {
        return this.module.version();
    }

    public void setup(String var1, String var2, String var3, String var4, String var5, String var6) throws FiscalModuleException {
        this.module.setup(var1, this.toBytes(var2), this.toBytes(var3), this.toBytes(var4), this.toBytes(var5), this.toBytes(var6));
    }

    public void init(String var1, String var2, String var3, String var4, boolean var5) throws FiscalModuleException {
        this.module.init(var1, var2, var3, var4, var5, (DocumentProcessCallback)this);
    }

    public void setTaxRates(int var1, String var2) throws FiscalModuleException {
        TaxType taxType = TaxType.VAT;
        if (var1 == 1) {
            taxType = TaxType.ST;
        }
        this.module.setTaxRates(taxType, this.toBytes(var2));
    }

    public void start() throws FiscalModuleException {
        this.module.start();
    }

    public void stop() throws FiscalModuleException {
        this.module.stop();
    }

    public boolean isReady() {
        return this.module.isReady();
    }

    public boolean isRunning() {
        return this.module.isRunning();
    }

    public int getQueueSize() {
        return this.module.getQueueSize();
    }

    public String processDocument(String var1) throws FiscalModuleException {
        return this.fromBytes(this.module.processDocument(this.toBytes(var1)));
    }

    public String getCounters() throws FiscalModuleException {
        return this.fromBytes(this.module.getCounters());
    }

    public boolean isShiftOpened() throws FiscalModuleException {
        return this.module.getState().isShiftOpened();
    }

    public long getExpirationDate() throws FiscalModuleException {
        Date date = this.module.getState().getExpirationDate();
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public String makeToken() throws FiscalModuleException {
        return this.module.makeToken();
    }

    public String getPublicKey() throws FiscalModuleException {
        return SoftwareFiscaleModuleWrapper.byteArrayToHexString(this.module.getPublicKey());
    }

    public void handleProcessResult(DocumentProcessResult arg0, byte[] arg1, byte[] arg2) {
    }
}

