#!/bin/bash

if (( $EUID != 0 )); then
	echo "Please run this script as root"
	exit
fi

echo "Installing NewCas software...";

if ! dotnet --list-runtimes  | grep -q '6.0'; then
  echo "Installing .NET 6.0 Runtime..."
  apt-get update && apt-get install -y dotnet-runtime-6.0
else
  echo ".NET runtime is installed."
fi

echo "Configuring system..."

timedatectl set-timezone Asia/Bishkek

echo "Installing fiscal service...";

cd $(dirname $0)
BASEDIR=$(pwd)

systemctl stop NewCasLinuxService > /dev/null 2>&1 

if [[ "$BASEDIR" != "/newcas/fiscal" ]]; then
    echo "Copying files...";
    mkdir -p /newcas/fiscal
	cp -a $BASEDIR/. /newcas/fiscal/
fi

cp -rf $BASEDIR/NewCasFiscalService.service /etc/systemd/system/NewCasFiscalService.service

echo "Reloading systemd...";

systemctl daemon-reload
systemctl start NewCasFiscalService  
systemctl enable NewCasFiscalService

chmod 755 /newcas/fiscal/install.sh
chmod 755 /newcas/fiscal/uninstall.sh

echo "Done";